% (C) 2001-2021 Intel Corporation. All rights reserved.
% Your use of Intel Corporation's design tools, logic functions and other 
% software and tools, and its AMPP partner logic functions, and any output 
% files from any of the foregoing (including device programming or simulation 
% files), and any associated documentation or information are expressly subject 
% to the terms and conditions of the Intel Program License Subscription 
% Agreement, Intel FPGA IP License Agreement, or other applicable 
% license agreement, including, without limitation, that your use is for the 
% sole purpose of programming logic devices manufactured by Intel and sold by 
% Intel or its authorized distributors.  Please refer to the applicable 
% agreement for further details.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %{tool}
% file : fft_tb.m
%
% Description : The following Matlab testbench excercises the Altera FFT Model fft_model.m
% generated by Altera's FFT Megacore and outputs results to text files.
%
% 2001-2007 Altera Corporation, All Rights Reserved
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Read transform sizes from source text file
fidnps = fopen('blksize_report.txt','r');
% Note: blksize_report.txt is generated when the HDL simulation is run, so if it does
% not exist then flag an error
if fidnps == -1 
  msgbox('Error: blksize_report does not exist, run the HDL simulation first.', 'blksize_report.txt missing', 'error');
else
  % Read input complex vector, and transform sizes from source text files 
  fidr = fopen('real_input.txt','r');                                            
  fidi = fopen('imag_input.txt','r');  
  xreali=fscanf(fidr,'%d');                                                      
  ximagi=fscanf(fidi,'%d');      
  nps=fscanf(fidnps,'%d');
  fclose(fidi);                                                                  
  fclose(fidr);   
  fclose(fidnps); 
  % Create input complex row vector from source text files 
  x = xreali' + j*ximagi';
  [y] = fft_model(x,nps); 
  fidro = fopen('real_output_c_model.txt','w');                                  
  fidio = fopen('imag_output_c_model.txt','w');
    fprintf(fidro,'%d\n',real(y));                                                 
    fprintf(fidio,'%d\n',imag(y));
  fclose(fidro);                                                                 
  fclose(fidio);
end

